function extras4schedulePersons(event)	{ // rev.2007-11-27

	// if  'extraInfo' is passed with no ORGANIZER, just return.
	// Note: SCHEDULE means there is at least a ORGANIZER
	//	RFC 2446 defines this as METHOD:PUBLISH
	if (event == null || event.extraInfo == null || event.extraInfo.indexOf("ORGANIZER") == -1 ){			
		return false;
	}

	var reminderFox_currentORGANIZERmail;
/* -------- 'Scheduled Persons'
				this adds the ORGANIZER/ATTENDEE data as Iconized display to XUL
*/
	var timeString = reminderFox_mail_getTimeString( event.date );
	var dateVariableString;
	try {
		dateVariableString = reminderFox_getUnicodePref(REMINDER_FOX_PREF + "." + REMINDER_FOX_LIST_DATE_LABEL);
	} catch(e) {}
	var schDTStart =reminderFox_getDateVariable( null, event.date, dateVariableString ) + "  " + timeString;

	var noAttendees=0;

	//	up to here long lines of 'event.extraInfo' are NOT merged !!!!
	//	So it's done here
	var cExtra = event.extraInfo.replace(new RegExp(/\\n /g),"");

	if ( (cExtra.indexOf("ORGANIZER") > -1)
		|| (cExtra.indexOf("ATTENDEE")  > -1) ) {

		var myMailAccounts = rmFxMsg.myMailIDs('from schedule.js');

		if (myMailAccounts == "" || myMailAccounts == null) {
			myMailAccounts = rmFx_mailAppSetup();}

		var schDtstamp ="";   var schSequence ="";    var schStatus ="";
		var schMail="";       var schClass="";
		var nAcc="";

		var extraInfoArray = cExtra.split("\\n");
		
		// first get ORGANIZER ... not to add it also as ATTENDEE later
		for ( var index = 0; index < extraInfoArray.length; index++ ) {
			var extraInfo = extraInfoArray[index];

			if ( extraInfo.indexOf( "ORGANIZER" ) != -1 ) {
				var organizerInfo = parsingScheduledPerson(extraInfoArray[index], "ORGANIZER");
			//	alert ("ORGANIZER: " + organizerInfo.CNAME);
			document.getElementById("organzierName")
				.setAttribute("value", organizerInfo.CNAME + "<"+ organizerInfo.MAIL +">");
				reminderFox_currentORGANIZERmail = 	organizerInfo.MAIL;
			}
		}
		// get the other items now
		for ( var index = 0; index < extraInfoArray.length; index++ ) {
			var extraInfo = extraInfoArray[index];

			// my parameters
			//id=schMyRole" 		src tooltiptext	ROLE:       roleString,
			//id="schMyRsvp" 		src tooltiptext   RSVP: 		rsvpString,
			//id="schMyPartStat" src tooltiptext	PARTSTAT:   pstatString,
			//id="schMyName"     value

// 'X-MICROSOFT-CDO-...' items cause erroneous processing	
	// X-MICROSOFT-CDO-BUSYSTATUS:BUSY\\n
	// X-MICROSOFT-CDO-INSTTYPE:0\\n
	// X-MICROSOFT-CDO-INTENDEDSTATUS:BUSY\\n
	// X-MICROSOFT-CDO-ALLDAYEVENT:FALSE\\n
	// X-MICROSOFT-CDO-IMPORTANCE:1\\nX-MICROSOFT-CDO-OWNERAPPTID:-435243049\\n
	// X-MICROSOFT-CDO-APPT-SEQUENCE:0\\n
	// X-MICROSOFT-CDO-ATTENDEE-CRITICAL-CHANGE:20071114T081656Z\\n
	// X-MICROSOFT-CDO-OWNER-CRITICAL-CHANGE:20071114T081656Z"
// 	.. and we don't need them here, so skip it!!

			if ( extraInfo.indexOf( "X-MICROSOFT-CDO-" ) == -1 ) {

			if ( extraInfo.indexOf( "ATTENDEE" ) != -1 ) {
				var attendeeInfo = parsingScheduledPerson(extraInfoArray[index], "ATTENDEE");

			// check if attendee is 'myMailAccounts'
				var mPos =	myMailAccounts.toLowerCase().indexOf( "<" + attendeeInfo.MAIL.toLowerCase() + ">" );

				// don't add if it's the ORGANIZER
				if (reminderFox_currentORGANIZERmail != attendeeInfo.MAIL) {
					if (mPos > -1) {  // it'a TRUE:  this mail-adr is part of "myAccounts"

						var iNeedAction = elementAttendees('schMeBox',attendeeInfo);
						
						// if iNeedAction (my & RSVP)  then colorize the element 
						document.getElementById("scheduleMe").setAttribute("hidden", false);
						if (iNeedAction == true) {
							var schText = document.getElementById("scheduleMeText")
							schText.style.fontWeight= "bold";
							schText.style.color= "blue";

							document.getElementById("rf-iCal-my-Reply-Accept").setAttribute("hidden", false);
							document.getElementById("rf-iCal-my-Reply-Decline").setAttribute("hidden", false);
						}
					}
					else {  // more Attendee(s)
						document.getElementById("schMoreAttendees")
							.setAttribute("hidden", false);
						elementAttendees('schAttendeesBox',attendeeInfo);
						noAttendees ++;
						document.getElementById("attendees")
							.setAttribute("label", "+ " + noAttendees);
					}
				}
			}

		//	reading from "extraInfo" string
			if ( extraInfo.indexOf( "DTSTAMP" ) != -1 ) {
				var colonIndex = extraInfo.indexOf( ":" );
				schDtstamp = reminderFox_parseDateTimes(extraInfo.substring(colonIndex +1));
			}
			if ( extraInfo.indexOf( "SEQUENCE" ) != -1 ) {
				var colonIndex = extraInfo.indexOf( ":" );
				schSequence =  extraInfo.substring(colonIndex +1);
			}
			if ( extraInfo.indexOf( "STATUS" ) != -1 ) {
				var colonIndex = extraInfo.indexOf( ":" );
				schStatus =  extraInfo.substring(colonIndex +1);
			}
			if ( extraInfo.indexOf( "DTEND" ) != -1 ) {
				var colonIndex = extraInfo.indexOf( ":" );
				var schDTEnd = reminderFox_parseDateTimes(extraInfo.substring(colonIndex +1));
			}
			if ( extraInfo.indexOf( "CLASS" ) != -1 ) {
				var colonIndex = extraInfo.indexOf( ":" );
				var schClass = extraInfo.substring(colonIndex +1);
			}
			} // X-MICROSOFT-CDO-
		}
		// schedule  as of sequence status	etc ..
		var statusText = reminderFox_getBundle().getString("rf.schedule.asof") + schDtstamp + "	[# " + schSequence + "]";

		if (schStatus != "" ) {statusText += "  [" + schStatus +"]"};
		if (schClass  != "" ) {statusText += "  [" + schClass  +"]"};

		document.getElementById("scheduleInfos1")
			.setAttribute("value", "  " + statusText);

		if (schDTEnd != null ) {
			document.getElementById("scheduleInfos2")
				.setAttribute("value",
					reminderFox_getBundle().getString("rf.schedule.begin") + ": " + schDTStart +  "	"
				 + reminderFox_getBundle().getString("rf.schedule.end")   + ": " + schDTEnd);
			document.getElementById("scheduleInfos2Box")
				.setAttribute("hidden","false");
		}
		return true;
	} else
		return false;
}

function parsingScheduledPerson(person, personTyp) {
/* ----------------------------------------------------
	parse and sort items
			//  ORGANIZER:MAILTO:theboss@xxxx.zzz
			//  ATTENDEE;PARTSTAT=ACCEPTED;ROLE=REQ-PARTICIPANT:mailto:luckyguy@xxxx.zzz
			//  ATTENDEE;RSVP=FALSE;CUTYPE=ROOM:conf_Big@example.com
			//  ATTENDEE;ROLE=CHAIR;PARTSTAT=ACCEPTED;CN=BIG A:Mailto:A@example.com
*/
		var fndIndex;     var semkiIndex;       var colnIndex;
		var nMail="";     var namString="";     var optString="";
		var fndString=""; var roleString="";
		var pstatString=""; var rsvpString="";  var cutypString="";

			var optString =  person.substring( personTyp.length +1 );

			var fndIndex = optString.toUpperCase().lastIndexOf( "MAILTO:");
			if (fndIndex != -1) {
				nMail = optString.substring( fndIndex + 7);
			} else {
				colnIndex = optString.lastIndexOf(":");
				if 		(colnIndex != -1) {
						var xx= optString.substring( colnIndex);
					if 	(xx.indexOf("@") != -1) {
							nMail = optString.substring( colnIndex + 1); }
				}
			}

			fndIndex = optString.toUpperCase().indexOf( "CN=" );
			if (fndIndex != -1) {
				fndString = optString.substring( fndIndex + 3);
				colnIndex = fndString.indexOf(":");
				semkiIndex = fndString.indexOf(";");

				if ((semkiIndex != -1) && (semkiIndex < colnIndex))  {
					namString = fndString.substring( 0, semkiIndex);
				} else {namString = fndString.substring( 0, colnIndex);  }
			}

			fndIndex = optString.toUpperCase().indexOf( "ROLE=" );
			if (fndIndex != -1) {
				if (optString.toUpperCase().indexOf("ROLE=CHAIR") != -1)
					roleString =  "CHAIR";
				if (optString.toUpperCase().indexOf("ROLE=REQ") != -1)	// "REQ-PARTICIPANT"
					roleString =  "REQUIRED-PARTICIPANT";
				if (optString.toUpperCase().indexOf("ROLE=OPT") != -1)  // "OPT-PARTICIPANT"
					roleString =  "OPTIONAL-PARTICIPANT";
				if (optString.toUpperCase().indexOf("ROLE=NON") != -1)	// "NON-PARTICIPANT"
					roleString =  "NON-PARTICIPANT";
			}

			fndIndex = optString.toUpperCase().indexOf( "PARTSTAT=" );
			if (fndIndex != -1) {
				if (optString.toUpperCase().indexOf("PARTSTAT=NEEDS-ACTION") != -1) //"NEEDS-ACTION"
					pstatString =  "NEEDS-ACTION";
				if (optString.toUpperCase().indexOf("PARTSTAT=ACCEPTED") != -1)	//"ACCEPTED"
					pstatString =  "Status-ACCEPTED";
				if (optString.toUpperCase().indexOf("PARTSTAT=TENTATIVE") != -1)	//"TENTATIVE"
					pstatString = "Status-TENTATIVE";
				if (optString.toUpperCase().indexOf("PARTSTAT=DECLINED") != -1)	//"DECLINED"
					pstatString = "Status-DECLINED";
		}

			fndIndex = optString.toUpperCase().indexOf( "RSVP=" );
			if (fndIndex != -1) {
				if (optString.toUpperCase().indexOf("RSVP=TRUE") != -1)
					rsvpString = "RSVP";
			}

			fndIndex = optString.toUpperCase().indexOf( "CUTYPE=" );
			if (fndIndex != -1) {
				if (optString.toUpperCase().indexOf("CUTYPE=INDIVIDUAL") != -1)
					cutypString = "INDIVIDUAL";
				if (optString.toUpperCase().indexOf("CUTYPE=GROUP") != -1)
					cutypString = "GROUP";
				if (optString.toUpperCase().indexOf("CUTYPE=RESOURCE") != -1)
					cutypString = "RESOURCE";
				if (optString.toUpperCase().indexOf("CUTYPE=ROOM") != -1)
					cutypString = "ROOM";
				if (optString.toUpperCase().indexOf("CUTYPE=UNKNOWN") != -1)
					cutypString = "UNKNOWN";
			}
		return  { CNAME:		namString,		MAIL:		nMail,
				     ROLE:		roleString,		PARTSTAT:	pstatString, 
				     RSVP:		rsvpString,		CUTYP:		cutypString	};
}


var reminderfox_myATTENDEEmail;

function elementAttendees(element,personsData) {
/* --------- this adds the persons (icons, tooltip & mail) to 'element' hbox 
*/
	var aList = document.getElementById(element);
	var hbox = document.createElement("hbox");
	var iNeedAction= false;

	var e = document.createElement("image");				//		RSVP
			if (personsData.RSVP !="") {
				if ( element == 'schMeBox') {
					iNeedAction = true;
					e.setAttribute("id", "myRSVP");
					e.setAttribute("tooltiptext", personsData.RSVP 
							+ reminderFox_getBundle().getString('rf.schedule.selectResponse'));
					reminderfox_myATTENDEEmail=personsData.MAIL;
					}
				else {
					e.setAttribute("id", "schRSVP");
					e.setAttribute("tooltiptext", personsData.RSVP); }
			} else {
				e.setAttribute("id", "persons"); }
	hbox.appendChild(e);


	var e = document.createElement("image");				//		ROLE
			if (personsData.ROLE !="") {

				e.setAttribute("tooltiptext", personsData.ROLE);
				e.setAttribute("id", personsData.ROLE);
//				e.setAttribute("onclick", "rmFx_attSTATchange(this);");		// ROLE changeable

			} else {
				e.setAttribute("id", "persons");
			}

	hbox.appendChild(e);

	var e = document.createElement("image");				//		PARTIZIPATION
			if (personsData.PARTSTAT !="") {
				e.setAttribute("id", personsData.PARTSTAT);
				if ( (element == 'schMeBox') &&
						((personsData.PARTSTAT == "Status-ACCEPTED")
					|| (personsData.PARTSTAT == "Status-DECLINED")) ) { // for mySchedule w. AVV or DECL  make it selectable
					e.setAttribute("tooltiptext", personsData.PARTSTAT
						+ ";  " +reminderFox_getBundle().getString("rf.schedule.changeStatus"));
					e.setAttribute("onclick", "rmFx_myPARTSTATchange(this);");
				} else {
					e.setAttribute("tooltiptext", personsData.PARTSTAT );
				}
			} else {
				e.setAttribute("id", "persons"); }
	hbox.appendChild(e);

//	<spacer  width="5px" />
	var e = document.createElement("spacer");
			e.setAttribute("width", "5px");
	hbox.appendChild(e);

	var e = document.createElement("text");
		if ( element == 'schMeBox') {
			e.setAttribute("id", "myDataMAIL");
		} else {
			e.setAttribute("id", "personsDataMAIL");
		}
			e.setAttribute("value", personsData.CNAME + '<' + personsData.MAIL +'>');
	hbox.appendChild(e);

	aList.appendChild(hbox);

	return iNeedAction;
}

function rmFx_rsvpNow(myAction) {
/* --------------------------------------
*/	
	var reminderEvent = window.arguments[0].reminder;
	var saveNotes = reminderEvent.notes;			// don't loose the 'invitation' notes

	// now change entry for myATTENDEE
	// from [ACCEPT] [DECLINE]  entry  or  with changing the status
	var sender = document.getElementById("myDataMAIL").attributes[1].value
		// 		== "name<aaaa.bbbb@ccc.dd>"

	var len1 = sender.indexOf( "<" );
	var len2 = sender.indexOf( ">" );
	var sendMail = sender.substring(len1+1, len2);

	var extraInfo0 = reminderEvent.extraInfo.replace(new RegExp(/\\n /g),"");
	var extraInfoArray = extraInfo0.split("\\n");		

	//  build  extraInfo array for local use
	var localExtraInfoArray = new Array();
	var localExtraInfo;

	for ( var index = 0; index < extraInfoArray.length; index++ ) {
		var extraInfo = extraInfoArray[index];
		localExtraInfoArray[index] = extraInfo;

		if ( extraInfo.indexOf( "COMMENT" ) != -1 ) {
			extraInfoArray[index] = "";				// erase the ORGANIZER's 'COMMENT'
			//	localExtraInfoArray[index] = "";
		}

		if ( extraInfo.indexOf( "DTSTAMP" ) != -1 )	{
			var colonIndex = extraInfo.indexOf( ":" );	
			var nDTSTAMP  =  reminderFox_parseDateTimes(extraInfo.substring(colonIndex +1)) ;
			
			var extraInfoSchedule = "[iCal] " + myAction + ": " + reminderFox_getBundle().getString("rf.schedule") ;
			if ( nDTSTAMP != null && nDTSTAMP.length > 0 ) {
				extraInfoSchedule += " " + reminderFox_getBundle().getString("rf.schedule.asof") + " " + nDTSTAMP;
			}
		}
		if ( extraInfo.indexOf( "SEQUENCE" ) != -1 ) {
			var colonIndex = extraInfo.indexOf( ":" );
			var nSEQ =  extraInfo.substring(colonIndex +1);
			if ( nSEQ != null ) {
				var extraInfoSEQ = "	[# " + nSEQ + "]" ;
			}
		}
		if ( extraInfo.indexOf( "ORGANIZER" ) != -1 ) {
			var attendeeInfo = parsingScheduledPerson(extraInfoArray[index], "ORGANIZER");
			var mailToOrganizer = attendeeInfo.MAIL
		}
		
		
		if ( extraInfo.indexOf( "ATTENDEE" ) != -1 ) {
			var attendeeInfo = parsingScheduledPerson(extraInfoArray[index], "ATTENDEE");
			
			// check if attendee is 'myMailAccounts'
			if ((rmFxMsg.myMailIDs().toLowerCase().indexOf( attendeeInfo.MAIL.toLowerCase()) > -1)
				&& (attendeeInfo.MAIL  == sendMail)){

				if (attendeeInfo.CNAME != "") {
					var newAtt = "ATTENDEE;CN="+ attendeeInfo.CNAME +";PARTSTAT=" + myAction;
				} else {
					var newAtt = "ATTENDEE;PARTSTAT=" + myAction;
				}
				var fndIndex = extraInfo.toUpperCase().indexOf( "ROLE=" );
				if (fndIndex != -1) {
					var roleString="";
					if (extraInfo.toUpperCase().indexOf("ROLE=CHAIR") != -1)
						roleString =  "CHAIR";
					if (extraInfo.toUpperCase().indexOf("ROLE=REQ") != -1)	// "REQ-PARTICIPANT"
						roleString =  "REQ-PARTICIPANT";
					if (extraInfo.toUpperCase().indexOf("ROLE=OPT") != -1)  // "OPT-PARTICIPANT"
						roleString =  "OPT-PARTICIPANT";
					if (extraInfo.toUpperCase().indexOf("ROLE=NON") != -1)	// "NON-PARTICIPANT"
						roleString =  "NON-PARTICIPANT";
					if (roleString != "") {
						newAtt += ";ROLE="+ roleString;
					}
			}

				newAtt += ":MAILTO:" + attendeeInfo.MAIL;
				extraInfoArray[index] = newAtt;
				localExtraInfoArray[index] = newAtt;

			} else {
				extraInfoArray[index] = "";
			}
		}	
	}

	for ( var index = 0; index < extraInfoArray.length; index++ ) {
		if (extraInfoArray[index] != "") {  // only add non-empty lines
			if (index == 0) {
				extraInfo = extraInfoArray[index];
			} else {
				extraInfo += "\\n" + extraInfoArray[index];
			}
		}
		if (localExtraInfoArray[index] != "") {  // only add non-empty lines
			if (index == 0) {
				localExtraInfo = localExtraInfoArray[index];
			} else {
				localExtraInfo += "\\n" + localExtraInfoArray[index];
			}
		}
	}

	// now set this to '.notes'
	extraInfoSchedule += extraInfoSEQ ;
	document.getElementById("notesText").value = extraInfoSchedule + "\n\n" + saveNotes;

	// now we can send the RSVP-response to the ORGAINZER by mail 
	// with "METHOD:REPLY"
	var sendArray = new Array();
	sendArray[0] = reminderEvent;
	sendArray[0].extraInfo = extraInfo;
	sendArray[0].notes = extraInfoSchedule;		// only send 'reply' notes
	rmFx_sendEventNow(sendArray, "", "REPLY", sender, mailToOrganizer);


	// store the local
	reminderEvent.extraInfo = localExtraInfo;
	reminderFox_saveReminderOptions( reminderEvent );

	window.arguments[0].addReminder = true;

	reminderFox_saveOptions(false);	// don't go for 'reschedule'
}


function rmFx_showAttendees() {
/* --------------------------------------
*/
	var boxStatus = document.getElementById("schAttendeesBox0")
		getAttribute("hidden");

	if (boxStatus == "false") {
		document.getElementById("schAttendeesBox0").setAttribute("hidden", true);
	} else {
		document.getElementById("schAttendeesBox0").setAttribute("hidden", false);
	}
	sizeToContent();
}

// ---- for 'myPartizipation'  change the status ----
function rmFx_myPARTSTATchange(status) {  //coming in with eg.: status.id = "Status-ACCEPTED"

	//status.parentNode.childNodes[4].attributes[0].nodeValue = "neandr<neandr@gmx.de>"
	var myID = status.parentNode.childNodes[4].attributes[0].nodeValue;

	if (status.id.indexOf('ACCEPTED') == -1) {
		newPartStat = 'ACCEPTED';
	} else {
		newPartStat = 'DECLINED';
	}
	check = confirm(reminderFox_getBundle().getString("rf.schedule.changePartStatus") 
		+ ": '" + newPartStat +"'");

	if (check == true) {
	// myACTION =  'ACCEPTED'  or  'DECLINED'
		rmFx_rsvpNow(newPartStat);
	} else {
		// alert("canceled");
	}
}

// ---- for 'attendee'  change the status ----
function rmFx_attSTATchange(status) {  //coming in with eg.: status.id = "Status-ACCEPTED"

//	alert ("current status is: " + status.id)

	switch  (status.id) {
		case ("REQUIRED-PARTICIPANT"): {
			status.id = "OPTIONAL-PARTICIPANT";
			status.tooltipText = reminderFox_getBundle().getString("rf.schedule.roleOPT"); break;}
		case ("OPTIONAL-PARTICIPANT"): {
			status.id = "NON-PARTICIPANT";
			status.tooltipText = reminderFox_getBundle().getString("rf.schedule.roleNON"); break;}
		case ("NON-PARTICIPANT"): {
			status.id = "REQUIRED-PARTICIPANT";
			status.tooltipText = reminderFox_getBundle().getString("rf.schedule.roleREQ"); break;}
	}
}	